/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.brave;

import brave.ScopedSpan;
import brave.Span;
import brave.Tracer;
import java.io.IOException;
import zipkin2.Call;
import zipkin2.Callback;
import zipkin2.server.internal.brave.TracedCall;

public final class TracedCall<V>
extends Call<V> {
    final Tracer tracer;
    final Call<V> delegate;
    final String name;

    public TracedCall(Tracer tracer, Call<V> delegate, String name) {
        this.tracer = tracer;
        this.delegate = delegate;
        this.name = name;
    }

    public V execute() throws IOException {
        ScopedSpan span = this.tracer.startScopedSpan(this.name);
        try {
            Object object = this.delegate.execute();
            return (V)object;
        }
        catch (IOException | Error | RuntimeException e) {
            span.error(e);
            throw e;
        }
        finally {
            span.finish();
        }
    }

    public void enqueue(Callback<V> callback) {
        Span span = this.tracer.nextSpan().name(this.name).start();
        try {
            if (span.isNoop()) {
                this.delegate.enqueue(callback);
            } else {
                this.delegate.enqueue((Callback)new SpanFinishingCallback(callback, span));
            }
        }
        catch (Error | RuntimeException e) {
            span.error(e);
            span.finish();
            throw e;
        }
    }

    public void cancel() {
        this.delegate.cancel();
    }

    public boolean isCanceled() {
        return this.delegate.isCanceled();
    }

    public Call<V> clone() {
        return new TracedCall(this.tracer, this.delegate, this.name);
    }

    public String toString() {
        return "Traced(" + this.delegate + ")";
    }
}

