/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.cassandra3;

import java.util.List;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Import;
import zipkin2.server.internal.cassandra3.ZipkinCassandra3StorageConfiguration;
import zipkin2.server.internal.cassandra3.ZipkinCassandra3StorageProperties;
import zipkin2.storage.StorageComponent;
import zipkin2.storage.cassandra.CassandraStorage;

@ConditionalOnClass(value={CassandraStorage.class})
@EnableConfigurationProperties(value={ZipkinCassandra3StorageProperties.class})
@ConditionalOnProperty(name={"zipkin.storage.type"}, havingValue="cassandra3")
@ConditionalOnMissingBean(value={StorageComponent.class})
@Import(value={TracingSessionFactoryEnhancer.class})
public class ZipkinCassandra3StorageConfiguration {
    @Bean
    CassandraStorage.SessionFactory sessionFactory() {
        return CassandraStorage.SessionFactory.DEFAULT;
    }

    @Bean
    @ConditionalOnMissingBean
    StorageComponent storage(ZipkinCassandra3StorageProperties properties, CassandraStorage.SessionFactory sessionFactory, @Value(value="${zipkin.storage.strict-trace-id:true}") boolean strictTraceId, @Value(value="${zipkin.storage.search-enabled:true}") boolean searchEnabled, @Value(value="${zipkin.storage.autocomplete-keys:}") List<String> autocompleteKeys, @Value(value="${zipkin.storage.autocomplete-ttl:3600000}") int autocompleteTtl, @Value(value="${zipkin.storage.autocomplete-cardinality:20000}") int autocompleteCardinality) {
        return properties.toBuilder().strictTraceId(strictTraceId).searchEnabled(searchEnabled).autocompleteKeys(autocompleteKeys).autocompleteTtl(autocompleteTtl).autocompleteCardinality(autocompleteCardinality).sessionFactory(sessionFactory).build();
    }
}

