/*
 * Decompiled with CFR 0.152.
 */
package zipkin2.server.internal.elasticsearch;

import com.linecorp.armeria.client.ClientFactory;
import com.linecorp.armeria.client.ClientOptions;
import com.linecorp.armeria.client.ClientOptionsBuilder;
import com.linecorp.armeria.client.WebClient;
import com.linecorp.armeria.client.encoding.DecodingClient;
import com.linecorp.armeria.client.endpoint.EndpointGroup;
import com.linecorp.armeria.client.logging.ContentPreviewingClient;
import com.linecorp.armeria.client.logging.LoggingClient;
import com.linecorp.armeria.client.logging.LoggingClientBuilder;
import com.linecorp.armeria.client.metric.MetricCollectingClient;
import com.linecorp.armeria.common.HttpHeaderNames;
import com.linecorp.armeria.common.HttpHeaders;
import com.linecorp.armeria.common.SessionProtocol;
import com.linecorp.armeria.common.logging.LogLevel;
import com.linecorp.armeria.common.metric.MeterIdPrefixFunction;
import java.io.Closeable;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Function;
import zipkin2.server.internal.elasticsearch.HttpClientFactory;
import zipkin2.server.internal.elasticsearch.ZipkinElasticsearchStorageProperties;

public class HttpClientFactory
implements Function<EndpointGroup, WebClient>,
Closeable {
    final SessionProtocol protocol;
    final ClientOptions options;
    final ClientFactory clientFactory;
    final int timeout;
    final List<Consumer<ClientOptionsBuilder>> customizers;

    HttpClientFactory(ZipkinElasticsearchStorageProperties es, ClientFactory factory, SessionProtocol protocol, List<Consumer<ClientOptionsBuilder>> customizers) {
        this.clientFactory = factory;
        this.protocol = protocol;
        this.customizers = customizers;
        this.timeout = es.getTimeout();
        ZipkinElasticsearchStorageProperties.HttpLogging httpLogging = es.getHttpLogging();
        ClientOptionsBuilder options = ClientOptions.builder().decorator(MetricCollectingClient.newDecorator((MeterIdPrefixFunction)MeterIdPrefixFunction.ofDefault((String)"elasticsearch"))).decorator(DecodingClient.newDecorator());
        this.configureHttpLogging(httpLogging, options);
        this.options = this.configureOptionsExceptHttpLogging(options).build();
    }

    void configureHttpLogging(ZipkinElasticsearchStorageProperties.HttpLogging httpLogging, ClientOptionsBuilder options) {
        if (httpLogging == ZipkinElasticsearchStorageProperties.HttpLogging.NONE) {
            return;
        }
        LoggingClientBuilder loggingBuilder = LoggingClient.builder().requestLogLevel(LogLevel.INFO).successfulResponseLogLevel(LogLevel.INFO).requestHeadersSanitizer((ctx, headers) -> {
            if (!headers.contains((CharSequence)HttpHeaderNames.AUTHORIZATION)) {
                return headers;
            }
            return headers.toBuilder().set((CharSequence)HttpHeaderNames.AUTHORIZATION, "****").build();
        });
        switch (1.$SwitchMap$zipkin2$server$internal$elasticsearch$ZipkinElasticsearchStorageProperties$HttpLogging[httpLogging.ordinal()]) {
            case 1: {
                loggingBuilder.contentSanitizer((ctx, unused) -> "");
                break;
            }
            case 2: {
                loggingBuilder.contentSanitizer((ctx, unused) -> "");
                loggingBuilder.headersSanitizer((ctx, unused) -> HttpHeaders.of());
                break;
            }
        }
        options.decorator(loggingBuilder.newDecorator());
        if (httpLogging == ZipkinElasticsearchStorageProperties.HttpLogging.BODY) {
            options.decorator(ContentPreviewingClient.newDecorator((int)Integer.MAX_VALUE));
        }
    }

    @Override
    public WebClient apply(EndpointGroup endpoint) {
        return WebClient.builder((SessionProtocol)this.protocol, (EndpointGroup)endpoint).options(this.options).build();
    }

    @Override
    public void close() {
        this.clientFactory.close();
    }

    ClientOptionsBuilder configureOptionsExceptHttpLogging(ClientOptionsBuilder options) {
        options.factory(this.clientFactory).responseTimeoutMillis((long)this.timeout).writeTimeoutMillis((long)this.timeout);
        this.customizers.forEach(c -> c.accept(options));
        return options;
    }
}

